$(function() {
	var userId = 5;
	var userIdMap = {"userId":userId};
	
	var urlvars = getUrlVars();
	var activityId = parseInt(urlvars['id'], 10);
	var activityIdMap = {"activityId":activityId};
	
	$('#div-two').on('click','button#back',function(e){
		document.location='./project-participants.html?id='+activityId;
	});
	
	$('#div-two').on('click','button#next',function(e){
		// TODO- how about checking if the page is dirty before doing all this?
		
		// save the project data source selections
		var hipaaConsent = $('#div-six input#hipaaConsentYes').is(':checked');
		var hipaaWaiver = $('#div-six input#hipaaWaiverYes').is(':checked');
		var startDate = $('#div-four input#useStartDate').val();
		var endDate = $('#div-four input#useEndDate').val();
		var locationName = 'locationName';
		var dataSources = [];
		
		$('#div-three table tbody tr.dsr input:checked').each(function() {
			$this = $(this);
			var id = $this.attr('name');
			dataSources.push(parseInt(id,10));
		});
		
		var d2 = new Object();
		d2['userId'] = 5;
		d2['activityId'] = activityId;
		d2['hipaaAuth'] = hipaaConsent;
		d2['hipaaWaiver'] = hipaaWaiver;
		d2['locationName'] = locationName;
		d2['startDate'] = startDate;
		d2['endDate'] = endDate;
		d2['dataSources'] = dataSources;
		
		// TODO- pass the request id, not the activitiy ID
		$.ajax({
			url:'../dart/saveRequestDataSources.json',
			type:'POST',
			contentType:'application/json',
			dataType:'json',
			data:JSON.stringify(d2),
			success:function(data,textStatus,three) {
				if(textStatus==="success" ) {
					document.location='./project-documents.html?id='+urlvars['id'];
				}
			}
		});
		
	});

	$('#div-one').on('change','select#sel-source',function(e){

		//TODO- make that data source name combo box a filter on the data source table.
	});
	
	// populate the data source table
	$.ajax({
		url:'../dart/getAllDataSources.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(userIdMap),
		success:function(data,textStatus,three) {
			if(textStatus==="success" ){
				var rlist = data.dataSources;
				if (rlist.length > 0) {
					var tableBody = Mustache.render($(".dataSourceRowTemplate").html(),data);
					$('#div-three table tbody').html(tableBody);
					
					// figure out the list of distinct data source names
					var sourceNameList = [];
					for (var i in rlist) {
						var obj = {"name":rlist[i].name};
						sourceNameList.push(obj);
					}
					var sourceObj = {"sources":sourceNameList};
					var optionsList = Mustache.render($(".dsNameOptionTemplate").html(),sourceObj);
					$('#div-one select#sel-source').html(optionsList);
					
					// TODO- pass the request id, not the activitiy ID
					// populate the activity data sources info
					$.ajax({
						url:'../dart/getRequestDataSources.json',
						type:'POST',
						contentType:'application/json',
						dataType:'json',
						data:JSON.stringify(activityIdMap),
						success:function(data,textStatus,three) {
							if(textStatus==="success" ) {
								var rlist2 = data.dataSources;
								if (rlist2.length > 0) {
									for (var i in rlist2) {
										var dsId2 = rlist2[i].dsId;
										// find the data source row and check it's checkbox
										$('#div-three table tbody tr.dsr input[name='+dsId2+']').attr('checked','checked');
									}
								}
								
								// TODO- what about the data use start and end date text boxes?
							}
						}
					});
				}
			}
		}
	});

	// populate the user request info
	$.ajax({
		url:'../dart/getActivityInfo.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(activityIdMap),
		success:function(data,textStatus,three) {
			if(textStatus==="success" ) {
				var projectName = Mustache.render($(".projectNameTemplate").html(),data);
				$('div#div-zero').html(projectName);
				var tableBody = Mustache.render($(".projectDatesTemplate").html(),data);
				$('div#div-four table tbody').html(tableBody);
			}
		}
	});
	
	// populate activity locations combo box
	$.ajax({
		url:'../dart/getActivityLocations.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(activityIdMap),
		success:function(data,textStatus,three) {
			if(textStatus==="success" ) {
				var locations = Mustache.render($(".projectLocationsTemplate").html(),data);
				$('div#div-five table tbody select').html(locations);
				// TODO- find the project locations
			}
		}
	});
});

//Read a page's GET URL variables and return them as an associative array.
getUrlVars = function()
{
  var vars = [], hash;
  var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
  for(var i = 0; i < hashes.length; i++)
  {
      hash = hashes[i].split('=');
      vars.push(hash[0]);
      vars[hash[0]] = hash[1];
  }
  return vars;
}